--[[----------------------------------------------------------------------------

ServiceProvider.lua
Export service provider description for Lightroom Lumethic uploader

------------------------------------------------------------------------------]]

-- Lumethic plug-in
require "ExportDialogSections"
require "Task"

--============================================================================--

return {
	
	hideSections = { 'exportLocation' },

	allowFileFormats = { 'RAW' },
	
	allowColorSpaces = nil,

	exportPresetFields = {
		{ key = 'apiUrl', default = 'https://api.lumethic.com' },
		{ key = 'apiKey', default = '' },
	},

	startDialog = ExportDialogSections.startDialog,
	sectionsForBottomOfDialog = ExportDialogSections.sectionsForBottomOfDialog,
	
	processRenderedPhotos = Task.processRenderedPhotos,
	
} 